/* FORM CONTACT */
//BASE_URL = 'http://localhost:8080/';
BASE_URL = 'https://tradsul.com.br/';

$('#contact-form').validate({
    errorElement: 'span',
    errorPlacement: function (error, element) {
        error.addClass('invalid-feedback');
        element.closest('.input-group').append(error);
    },
    highlight: function (element, errorClass, validClass) {
        $(element).addClass('is-invalid');
    },
    unhighlight: function (element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
    },
    submitHandler: function (form) {
        $.ajax({
            url: BASE_URL + 'contato/sendform',
            type: 'GET',
            data: $('#contact-form').serialize(),
            contentType: false,
            processData: false,
            //async: false, //blocks window close
            beforeSend: function (data) {
                //console.log(data);
                //msg("<b>Processando... Por favor, aguarde!<b>", 'alert');
            },
            success: function (response) {
                console.log(response);
                if (response === 'TRUE') {
                    $('.message-status').fadeIn('slow', function () {
                        $(this).text('Mensagem enviada com sucesso!');
                    });
                } else if (response === 'FALSE') {
                    $('.message-status').fadeIn('slow', function () {
                        $(this).text('Mensagem não enviada!');
                    });
                }
            },
            error: function (data) {
                //console.log(data);
                //$.unblockUI();
                $('.message-status').fadeIn('slow', function () {
                    $(this).text('Erro crítico! Por favor, consulte o administrador do sistema!');
                });
            }
        });
    }
});