<!doctype html>
<html class="no-js" lang="pt-br">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>Tradsul - Mecanica</title>
	<meta name="robots" content="noindex, follow">
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- STYLES -->
	@include('br.partials.style')
</head>

<body>
	<!-- page wrapper -->
	<div class="page-wrapper">

		<!-- Header Main Area -->
		<header class="site-header header-style-3">
			@include('br.partials.top-bar')
			<div class="site-header-menu d-flex justify-content-between align-items-center">
				<div class="container-fluid g-0">
					<div class="row g-0">
						<div class="col-md-12">
							<div class="d-flex align-items-center justify-content-between">
								@include('br.partials.menu')
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header Main Area End Here -->


		<!-- Title Bar -->
		<div class="pbmit-title-bar-wrapper es-mecanica">
			<div class="container">
				<div class="pbmit-title-bar-content">
					<div class="pbmit-title-bar-content-inner">
						<div class="pbmit-tbar">
							<div class="pbmit-tbar-inner">
								<h1 class="pbmit-tbar-title text-white">Mecânica</h1>
							</div>
						</div>
						<div class="pbmit-breadcrumb">
							<div class="pbmit-breadcrumb-inner">
								<span><a title="" href="#" class="home"><span>Home</span></a></span>
								<span class="sep">-</span>
								<span><span>Especialidades</span></span>
								<span class="sep">-</span>
								<span><span class="post-root post post-post current-item">Mecânica</span></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Title Bar End-->


		<!-- Page Content -->
		<div class="page-content pbmit-bg-color-light">


			<!-- Candidate  Details-->
			<section class="section-lg">
				<div class="container">
					<div class="row">
						<div class="col-12">
							<div class="row align-items-center">
								<div class="col-md-12 col-lg-4">
									<div class="pbmit-team-details-inner">
										<div class="pbmit-team-img">
											<img src="{{ asset('assets/images/specialty/mecanica.webp') }}"
												class="w-100" alt="">
										</div>
									</div>
								</div>
								<div class="col-md-12 col-lg-8">
									<div class="pbmit-team-summary">
										<h4 class="pbmit-team-designation">Especialidade</h4>
										<h2 class="pbmit-team-title">Mecanica</h2>
										<p>
											A perícia em engenharia mecânica desempenha um <strong>papel
												crucial</strong> tanto no âmbito
											jurídico quanto na indústria, sendo responsável por investigar e analisar
											questões técnicas relacionadas a sistemas, máquinas, equipamentos e
											componentes mecânicos.
										</p>
										<p>
											Contamos com uma equipe de <strong>peritos altamente qualificados</strong>
											especializados na
											realização de perícias de engenharia, dedicados ao estudo de falhas e
											acidentes em uma ampla variedade de máquinas e equipamentos. Exemplos
											incluem aerogeradores, turbinas hidráulicas, motogeradores, compressores,
											entre outros. Nosso trabalho abrange a identificação da causa raiz, apuração
											dos danos materiais e levantamento do valor em risco associado.
										</p>
										<p>
											Esses profissionais, com <strong>experiência sólida</strong> em engenharia mecânica, aplicam
											métodos analíticos avançados para fornecer avaliações precisas e detalhadas.
											Seja no contexto jurídico, para fundamentar processos legais, ou na
											indústria, para melhorar a eficiência operacional e garantir a segurança,
											nossa equipe de peritos está comprometida em oferecer soluções técnicas
											confiáveis e contribuir para a resolução eficaz de questões relacionadas a
											máquinas e equipamentos mecânicos.
										</p>
										<p>
											<strong>Veja como podemos ajuda-lo!</strong>
										<ul>
											<li>- Sinistros Residenciais e Empresariais;</li>
											<li>- Usinas Geradoras;</li>
											<li>- Transformadores;</li>
											<li>- Usinas Solar e Eólica.</li>
										</ul>
										</p>
									</div>
								</div>
							</div>

						</div>
					</div>
				</div>
			</section>
			<!-- Candidate  Details end -->
		</div>
		<!-- Page Content End -->

		<!-- Footer -->
		@include('br.partials.footer')
		<!-- Footer End -->

	</div>
	<!-- page wrapper End -->

	<!-- Search Box Start Here -->
	<div class="pbmit-search-overlay">
		<div class="pbmit-icon-close"></div>
		<div class="pbmit-search-outer">
			<form class="pbmit-site-searchform">
				<input type="search" class="form-control field searchform-s" name="Pesquisar …"
					placeholder="Pesquisar …">
				<button type="submit">
					<i class="pbmit-base-icon-search-1"></i>
				</button>
			</form>
		</div>
	</div>
	<!-- Search Box End Here -->

	<!-- JS
         ============================================ -->
	@include('br.partials.scripts')
	<script>
		$(".mn-specialty").addClass("active");
	</script>
</body>

</html>
