<!doctype html>
<html class="no-js" lang="pt-br">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>Tradsul - Química</title>
	<meta name="robots" content="noindex, follow">
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- STYLES -->
	@include('br.partials.style')
</head>

<body>
	<!-- page wrapper -->
	<div class="page-wrapper">

		<!-- Header Main Area -->
		<header class="site-header header-style-3">
			@include('br.partials.top-bar')
			<div class="site-header-menu d-flex justify-content-between align-items-center">
				<div class="container-fluid g-0">
					<div class="row g-0">
						<div class="col-md-12">
							<div class="d-flex align-items-center justify-content-between">
								@include('br.partials.menu')
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header Main Area End Here -->


		<!-- Title Bar -->
		<div class="pbmit-title-bar-wrapper es-quimica">
			<div class="container">
				<div class="pbmit-title-bar-content">
					<div class="pbmit-title-bar-content-inner">
						<div class="pbmit-tbar">
							<div class="pbmit-tbar-inner">
								<h1 class="pbmit-tbar-title text-white">Química</h1>
							</div>
						</div>
						<div class="pbmit-breadcrumb">
							<div class="pbmit-breadcrumb-inner">
								<span><a title="" href="#" class="home"><span>Home</span></a></span>
								<span class="sep">-</span>
								<span><span>Especialidades</span></span>
								<span class="sep">-</span>
								<span><span class="post-root post post-post current-item">Química</span></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Title Bar End-->


		<!-- Page Content -->
		<div class="page-content pbmit-bg-color-light">


			<!-- Candidate  Details-->
			<section class="section-lg">
				<div class="container">
					<div class="row">
						<div class="col-12">
							<div class="row align-items-center">
								<div class="col-md-12 col-lg-4">
									<div class="pbmit-team-details-inner">
										<div class="pbmit-team-img">
											<img src="{{ asset('assets/images/specialty/quimica.webp')  }}"
												class="w-100" alt="">
										</div>
									</div>
								</div>
								<div class="col-md-12 col-lg-8">
									<div class="pbmit-team-summary">
										<h4 class="pbmit-team-designation">Especialidade</h4>
										<h2 class="pbmit-team-title">Química</h2>
										<p>
											A perícia em engenharia química destina-se à <strong>análise técnica e
												científica</strong> de questões relacionadas a processos químicos,
											produtos químicos, reações químicas, instalações industriais e desafios
											inerentes à química.
										</p>
										<p>
											Contamos com uma equipe de profissionais <strong>altamente
												capacitados</strong> e experientes em sinistros de grande escala. Nossa
											expertise abrange a realização de perícias em processos químicos
											industriais, análise de avarias em embalagens e produtos, investigação de
											falhas por degradação, avaliação de recusas de produtos, identificação de
											contaminação, estudo de transporte e armazenamento de materiais, entre
											outros aspectos relevantes.
										</p>
										<p>
											Ao lidar com <strong>casos complexos</strong>, nossa abordagem técnica e
											minuciosa visa fornecer análises precisas e soluções fundamentadas. Nosso
											compromisso é oferecer uma compreensão abrangente dos desafios específicos
											da engenharia química, contribuindo para a resolução eficaz de questões
											relacionadas à indústria química. A qualidade de nossas perícias é
											respaldada pela combinação de conhecimento especializado e experiência
											prática, garantindo uma avaliação confiável e abrangente em situações
											diversas.
										</p>
										<p>
											<strong>Veja como podemos ajuda-lo!</strong>
										<ul>
											<li>- Processos Industriais;</li>
											<li>- Análises de produtos e matérias primas;</li>
											<li>- Danos em transporte de produtos químicos.</li>
										</ul>
										</p>
									</div>
								</div>
							</div>

						</div>
					</div>
				</div>
			</section>
			<!-- Candidate  Details end -->
		</div>
		<!-- Page Content End -->

		<!-- Footer -->
		@include('br.partials.footer')
		<!-- Footer End -->

	</div>
	<!-- page wrapper End -->

	<!-- Search Box Start Here -->
	<div class="pbmit-search-overlay">
		<div class="pbmit-icon-close"></div>
		<div class="pbmit-search-outer">
			<form class="pbmit-site-searchform">
				<input type="search" class="form-control field searchform-s" name="Pesquisar …"
					placeholder="Pesquisar …">
				<button type="submit">
					<i class="pbmit-base-icon-search-1"></i>
				</button>
			</form>
		</div>
	</div>
	<!-- Search Box End Here -->

	<!-- JS
         ============================================ -->
	@include('br.partials.scripts')
	<script>
		$(".mn-specialty").addClass("active");
	</script>
</body>

</html>
