<!doctype html>
<html class="no-js" lang="pt-br">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>Tradsul - Siderurgia</title>
	<meta name="robots" content="noindex, follow">
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- STYLES -->
	@include('br.partials.style')
</head>

<body>
	<!-- page wrapper -->
	<div class="page-wrapper">

		<!-- Header Main Area -->
		<header class="site-header header-style-3">
			@include('br.partials.top-bar')
			<div class="site-header-menu d-flex justify-content-between align-items-center">
				<div class="container-fluid g-0">
					<div class="row g-0">
						<div class="col-md-12">
							<div class="d-flex align-items-center justify-content-between">
								@include('br.partials.menu')
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header Main Area End Here -->


		<!-- Title Bar -->
		<div class="pbmit-title-bar-wrapper es-siderurgia">
			<div class="container">
				<div class="pbmit-title-bar-content">
					<div class="pbmit-title-bar-content-inner">
						<div class="pbmit-tbar">
							<div class="pbmit-tbar-inner">
								<h1 class="pbmit-tbar-title text-white">Siderurgia</h1>
							</div>
						</div>
						<div class="pbmit-breadcrumb">
							<div class="pbmit-breadcrumb-inner">
								<span><a title="" href="#" class="home"><span>Home</span></a></span>
								<span class="sep">-</span>
								<span><span>Especialidades</span></span>
								<span class="sep">-</span>
								<span><span class="post-root post post-post current-item">Siderurgia</span></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Title Bar End-->


		<!-- Page Content -->
		<div class="page-content pbmit-bg-color-light">


			<!-- Candidate  Details-->
			<section class="section-lg">
				<div class="container">
					<div class="row">
						<div class="col-12">
							<div class="row align-items-center">
								<div class="col-md-12 col-lg-4">
									<div class="pbmit-team-details-inner">
										<div class="pbmit-team-img">
											<img src="{{ asset('assets/images/specialty/siderurgia.webp') }}"
												class="w-100" alt="">
										</div>
									</div>
								</div>
								<div class="col-md-12 col-lg-8">
									<div class="pbmit-team-summary">
										<h4 class="pbmit-team-designation">Especialidade</h4>
										<h2 class="pbmit-team-title">Siderurgia</h2>
										<p>
											A perícia em siderurgia é <strong>especializada</strong> na investigação,
											análise e avaliação
											de questões técnicas relacionadas à produção e processamento de metais e
											aço.
										</p>
										<p>
											Nossa equipe de engenharia metalúrgica e materiais é composta por
											<strong>mestres e
												doutores especialistas</strong> com anos de experiência no setor
											siderúrgico, além de
											uma sólida vivência na área de pesquisa e desenvolvimento (P&D),
											processamento e caracterização de materiais.
										</p>
										<p>Atuamos na investigação de falhas em componentes e equipamentos em serviço,
											realizando uma análise abrangente que esclarece a falha, identifica o
											mecanismo causador e, por fim, determina a causa raiz.</p>
										<p>Nossos estudos seguem <strong>metodologias científicas</strong> aplicadas à
											Análise de Falhas,
											e nosso time dispõe de uma ampla gama de recursos que contribuem para a
											identificação dos agentes causadores da falha. Isso inclui a realização de
											ensaios metalúrgicos e mecânicos, Análise de Elementos Finitos (FEA) e
											outras técnicas avançadas.</p>
										<p><strong>Comprometidos com a excelência</strong>, garantimos que nossas perícias em siderurgia
											sejam conduzidas com precisão e rigor técnico, proporcionando resultados
											confiáveis e contribuindo para a otimização de processos industriais e
											aprimoramento da qualidade na produção de metais e aço.</p>
										<p>
											<strong>Veja como podemos ajuda-lo!</strong>
										<ul>
											<li>- Processos Industriais Siderúrgicos.</li>
											<li>- Usinas Integradas e não integradas.</li>
											<li>- Insumos Siderúrgicos.</li>
											<li>- Controle Ambiental.</li>
											<li>- Custo e Qualidade de Processos.</li>
										</ul>
										</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</section>
			<!-- Candidate  Details end -->
		</div>
		<!-- Page Content End -->

		<!-- Footer -->
		@include('br.partials.footer')
		<!-- Footer End -->

	</div>
	<!-- page wrapper End -->

	<!-- Search Box Start Here -->
	<div class="pbmit-search-overlay">
		<div class="pbmit-icon-close"></div>
		<div class="pbmit-search-outer">
			<form class="pbmit-site-searchform">
				<input type="search" class="form-control field searchform-s" name="Pesquisar …"
					placeholder="Pesquisar …">
				<button type="submit">
					<i class="pbmit-base-icon-search-1"></i>
				</button>
			</form>
		</div>
	</div>
	<!-- Search Box End Here -->

	<!-- JS
         ============================================ -->
	@include('br.partials.scripts')
	<script>
		$(".mn-specialty").addClass("active");
	</script>
</body>

</html>
