<!doctype html>
<html class="no-js" lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Tradsul - Chemical</title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- STYLES -->
    @include('en.partials.style')
</head>

<body>
<!-- page wrapper -->
<div class="page-wrapper">

    <!-- Header Main Area -->
    <header class="site-header header-style-3">
        @include('en.partials.top-bar')
        <div class="site-header-menu d-flex justify-content-between align-items-center">
            <div class="container-fluid g-0">
                <div class="row g-0">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center justify-content-between">
                            @include('en.partials.menu')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Main Area End Here -->


    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper es-quimica">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner">
                            <h1 class="pbmit-tbar-title text-white">Chemical</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span><a title="" href="#" class="home"><span>Home</span></a></span>
                            <span class="sep">-</span>
                            <span><span>Work Area</span></span>
                            <span class="sep">-</span>
                            <span><span class="post-root post post-post current-item">Chemical</span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Title Bar End-->


    <!-- Page Content -->
    <div class="page-content pbmit-bg-color-light">


        <!-- Candidate  Details-->
        <section class="section-lg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="row align-items-center">
                            <div class="col-md-12 col-lg-4">
                                <div class="pbmit-team-details-inner">
                                    <div class="pbmit-team-img">
                                        <img src="{{ asset('assets/images/specialty/quimica.webp')  }}"
                                             class="w-100" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-8">
                                <div class="pbmit-team-summary">
                                    <h4 class="pbmit-team-designation">Work Area</h4>
                                    <h2 class="pbmit-team-title">Chemical</h2>
                                    <p>
                                        Chemical engineering expertise is dedicated to the technical and scientific
                                        analysis of issues related to chemical processes, chemical products, chemical
                                        reactions, industrial facilities, and the challenges inherent to chemistry.
                                    </p>
                                    <p>
                                        We have a team of highly skilled and experienced professionals specializing in
                                        large-scale claims. Our expertise covers industrial chemical process
                                        investigations, damage analysis of packaging and products, failure
                                        investigations due to degradation, product rejection assessments, contamination
                                        identification, and the study of material transport and storage, among other
                                        relevant aspects.
                                    </p>
                                    <p>
                                        When handling complex cases, our technical and thorough approach aims to provide
                                        precise analyses and well-founded solutions. Our commitment is to offer a
                                        comprehensive understanding of the specific challenges of chemical engineering,
                                        contributing to the effective resolution of issues related to the chemical
                                        industry. The quality of our expertise is backed by a combination of specialized
                                        knowledge and practical experience, ensuring reliable and thorough assessments
                                        in various situations.
                                    </p>
                                    <p>
                                        <strong>Here’s how we can assist you!</strong>
                                    <ul>
                                        <li>- Industrial Processes;</li>
                                        <li>- Product and Raw Material Analysis;</li>
                                        <li>- Damage during Chemical Product Transport.</li>
                                    </ul>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <!-- Candidate  Details end -->
    </div>
    <!-- Page Content End -->

    <!-- Footer -->
    @include('en.partials.footer')
    <!-- Footer End -->

</div>
<!-- page wrapper End -->

<!-- Search Box Start Here -->
<div class="pbmit-search-overlay">
    <div class="pbmit-icon-close"></div>
    <div class="pbmit-search-outer">
        <form class="pbmit-site-searchform">
            <input type="search" class="form-control field searchform-s" name="Pesquisar …"
                   placeholder="Pesquisar …">
            <button type="submit">
                <i class="pbmit-base-icon-search-1"></i>
            </button>
        </form>
    </div>
</div>
<!-- Search Box End Here -->

<!-- JS
     ============================================ -->
@include('en.partials.scripts')
<script>
    $(".mn-specialty").addClass("active");
</script>
</body>

</html>
