<!doctype html>
<html class="no-js" lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Tradsul - Electrical</title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- STYLES -->
    @include('en.partials.style')
</head>

<body>
<!-- page wrapper -->
<div class="page-wrapper">

    <!-- Header Main Area -->
    <header class="site-header header-style-3">
        @include('en.partials.top-bar')
        <div class="site-header-menu d-flex justify-content-between align-items-center">
            <div class="container-fluid g-0">
                <div class="row g-0">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center justify-content-between">
                            @include('en.partials.menu')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Main Area End Here -->


    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper es-eletrica">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner">
                            <h1 class="pbmit-tbar-title text-white">Electrical</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span><a title="" href="#" class="home"><span>Home</span></a></span>
                            <span class="sep">-</span>
                            <span><span>Work Areas</span></span>
                            <span class="sep">-</span>
                            <span><span class="post-root post post-post current-item">Electrical</span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Title Bar End-->


    <!-- Page Content -->
    <div class="page-content pbmit-bg-color-light">


        <!-- Candidate  Details-->
        <section class="section-lg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="row align-items-center">
                            <div class="col-md-12 col-lg-4">
                                <div class="pbmit-team-details-inner">
                                    <div class="pbmit-team-img">
                                        <img src="{{ asset('assets/images/specialty/eletrica.webp') }}"
                                             class="w-100" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-8">
                                <div class="pbmit-team-summary">
                                    <h4 class="pbmit-team-designation">Work Areas</h4>
                                    <h2 class="pbmit-team-title">Electrical</h2>
                                    <p>
                                        Electrical expertise represents a specialized field dedicated to the
                                        investigation and analysis of incidents related to electricity. This area covers
                                        a wide range of situations, from electrical fires to accidents involving
                                        electricity and failures in electrical systems, among other events associated
                                        with electrical energy.
                                    </p>
                                    <p>
                                        Our team of experts consists of experienced professionals in conducting
                                        engineering investigations, focusing on in-depth studies of failures and
                                        accidents in electrical and electronic equipment. These specialists possess
                                        solid technical knowledge and extensive practical experience, ensuring a
                                        comprehensive and accurate approach to every investigation.
                                    </p>
                                    <p>
                                        When conducting investigations, our goal is to identify the root causes of
                                        incidents, thoroughly analyze the electrical components involved, and provide
                                        detailed reports that can be used to clarify responsibilities, improve systems,
                                        and prevent future adverse events.
                                    </p>
                                    <p>
                                        The expertise of our team, combined with the use of advanced analysis and
                                        instrumentation technologies, positions us as a reference in the field of
                                        electrical expertise, ensuring quality and reliability in every assessment
                                        conducted.
                                    </p>
                                    <p>
                                        <strong>Here’s how we can assist you!</strong>
                                    <ul>
                                        <li>- Residential and Commercial Claims;</li>
                                        <li>- Power Plants;</li>
                                        <li>- Transformers;</li>
                                        <li>- Solar and Wind Farms.</li>
                                    </ul>
                                    </p>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>
        <!-- Candidate  Details end -->
    </div>
    <!-- Page Content End -->

    <!-- Footer -->
    @include('en.partials.footer')
    <!-- Footer End -->

</div>
<!-- page wrapper End -->

<!-- Search Box Start Here -->
<div class="pbmit-search-overlay">
    <div class="pbmit-icon-close"></div>
    <div class="pbmit-search-outer">
        <form class="pbmit-site-searchform">
            <input type="search" class="form-control field searchform-s" name="Pesquisar …"
                   placeholder="Pesquisar …">
            <button type="submit">
                <i class="pbmit-base-icon-search-1"></i>
            </button>
        </form>
    </div>
</div>
<!-- Search Box End Here -->

<!-- JS
     ============================================ -->
@include('en.partials.scripts')
<script>
    $(".mn-specialty").addClass("active");
</script>
</body>

</html>
