<!doctype html>
<html class="no-js" lang="pt-br">

<head>
	<meta charset="utf-8">
	<meta http-equiv="x-ua-compatible" content="ie=edge">
	<title>Tradsul - História</title>
	<meta name="robots" content="noindex, follow">
	<meta name="description" content="">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<!-- STYLES -->
	@include('br.partials.style')
</head>

<body>
	<!-- page wrapper -->
	<div class="page-wrapper">

		<!-- Header Main Area -->
		<header class="site-header header-style-3">
			@include('br.partials.top-bar')
			<div class="site-header-menu d-flex justify-content-between align-items-center">
				<div class="container-fluid g-0">
					<div class="row g-0">
						<div class="col-md-12">
							<div class="d-flex align-items-center justify-content-between">
								@include('br.partials.menu')
							</div>
						</div>
					</div>
				</div>
			</div>
		</header>
		<!-- Header Main Area End Here -->


		<!-- Title Bar -->
		<div class="pbmit-title-bar-wrapper history">
			<div class="container">
				<div class="pbmit-title-bar-content">
					<div class="pbmit-title-bar-content-inner">
						<div class="pbmit-tbar">
							<div class="pbmit-tbar-inner">
								<h1 class="pbmit-tbar-title text-white">História</h1>
							</div>
						</div>
						<div class="pbmit-breadcrumb">
							<div class="pbmit-breadcrumb-inner">
								<span><a title="" href="#"><span class="home">Home</span></a></span>
								<span class="sep">-</span>
								<span><span>Quem Somos</span></span>
								<span class="sep">-</span>
								<span><span class="post-root post post-post current-item">História</span></span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Title Bar End-->


		<!-- Page Content -->
		<div class="page-content pbmit-bg-color-light">

			<!-- Our History -->
			<section class="section-lg active-onhover">
				<div class="container">
					<div class="about-content-one">
						<div class="row">
							<div class="col-md-12">
								<div class="pbmit-heading-subheading">
									<h4 class="pbmit-subtitle">Somos uma Companhia de desenvolvimento de soluções para
										Sinistros.</h4>
									<h2 class="pbmit-title">Nossa História</h2>
								</div>
								<div class="about-content-right" style="padding: 0px 0px 0px 0px;">
									<p>Fundada em 1997 pelo engenheiro industrial metalúrgico José Candido de Oliveira
										Filho, a Tradsul é uma <strong>destacada</strong> empresa brasileira
										especializada em consultoria
										e perícia técnica. Com uma <strong>atuação abrangente</strong> em diversas áreas
										da engenharia,
										incluindo Civil, Metalúrgica, Materiais, Química, Elétrica, Eletrônica,
										Automação, Mecânica, e Incêndio e Explosão, a Tradsul se destaca por sua
										<strong>flexibilidade operacional</strong> em todo o território nacional.
									</p>
									<p>A empresa conta com uma equipe de profissionais <strong>altamente
											capacitados</strong>,
										estabelecendo-se como referência ao buscar soluções inovadoras em seus projetos.
										Utilizando <strong>ferramentas avançadas</strong>, como simulações 3D,
										modelagens e ensaios, a
										Tradsul assegura a aplicação das melhores práticas na resolução dos desafios
										apresentados.
									</p>
									<p>O foco primordial da Tradsul é promover um trabalho investigativo que <strong>contribua
										significativamente</strong> para o aprimoramento de seus clientes, desempenhando um papel
										fundamental na resolução de desafios complexos na área de engenharia.</p>
									<p>A empresa reforça seu compromisso com a <strong>excelência e qualidade</strong>, consolidando-se
										como uma parceria confiável na busca por soluções eficientes e inovadoras no
										cenário da engenharia brasileira. A Tradsul, ao longo de sua trajetória,
										demonstra consistentemente sua capacidade de oferecer serviços de alta
										performance, sustentando sua posição como uma líder confiável e competente no
										setor.
									</p>
								</div>
							</div>
						</div>
					</div>

				</div>
			</section>
			<!-- Our History End -->
		</div>
		<!-- Page Content End -->

		<!-- Footer -->
		@include('br.partials.footer')
		<!-- Footer End -->

	</div>
	<!-- page wrapper End -->

	<!-- Search Box Start Here -->
	<div class="pbmit-search-overlay">
		<div class="pbmit-icon-close"></div>
		<div class="pbmit-search-outer">
			<form class="pbmit-site-searchform">
				<input type="search" class="form-control field searchform-s" name="Pesquisar …"
					placeholder="Pesquisar …">
				<button type="submit">
					<i class="pbmit-base-icon-search-1"></i>
				</button>
			</form>
		</div>
	</div>
	<!-- Search Box End Here -->

	<!-- JS
         ============================================ -->
	@include('br.partials.scripts')
	<script>
		$(".mn-about").addClass("active");
	</script>
</body>

</html>
