<?php

use Illuminate\Support\Facades\Route;
//PT-BR
use App\Http\Controllers\br\HomeController;
use App\Http\Controllers\br\HistoriaController;
use App\Http\Controllers\br\ValoresController;
use App\Http\Controllers\br\PilaresController;
use App\Http\Controllers\br\TexController;
use App\Http\Controllers\br\OndeEstamosController;
use App\Http\Controllers\br\EspecialidadeController;
use App\Http\Controllers\br\ContatoController;
//EN
use App\Http\Controllers\en\HomeController as EnHomeController;
use App\Http\Controllers\en\HistoryController;
use App\Http\Controllers\en\ValuesController;
use App\Http\Controllers\en\PillarsController;
use App\Http\Controllers\en\TexController as EnTexController;
use App\Http\Controllers\en\WhereWeAreController;
use App\Http\Controllers\en\SpecialtyController;
use App\Http\Controllers\en\ContactController as EnContactController;



// ROUTE BR
Route::get('/', [HomeController::class, 'index']);
Route::get('/historia', [HistoriaController::class, 'index']);
Route::get('/valores', [ValoresController::class, 'index']);
Route::get('/pilares', [PilaresController::class, 'index']);
Route::get('/tex', [TexController::class, 'index']);
Route::get('/onde-estamos', [OndeEstamosController::class, 'index']);
Route::get('/especialidade/incendio-explosao', [EspecialidadeController::class, 'incendio_explosao']);
Route::get('/especialidade/eletrica', [EspecialidadeController::class, 'eletrica']);
Route::get('/especialidade/civil', [EspecialidadeController::class, 'civil']);
Route::get('/especialidade/mecanica', [EspecialidadeController::class, 'mecanica']);
Route::get('/especialidade/quimica', [EspecialidadeController::class, 'quimica']);
Route::get('/especialidade/siderurgia', [EspecialidadeController::class, 'siderurgia']);
Route::get('/contato', [ContatoController::class, 'index']);


// ROUTE EN
Route::get('/en', [EnHomeController::class, 'index']);
Route::get('/en/history', [HistoryController::class, 'index']);
Route::get('/en/values', [ValuesController::class, 'index']);
Route::get('/en/pillars', [PillarsController::class, 'index']);
Route::get('/en/tex', [EnTexController::class, 'index']);
Route::get('/en/where-we-are', [WhereWeAreController::class, 'index']);
Route::get('/en/specialty/fire-explosion', [SpecialtyController::class, 'fire_explosion']);
Route::get('/en/specialty/electrical', [SpecialtyController::class, 'electrical']);
Route::get('/en/specialty/civil', [SpecialtyController::class, 'civil']);
Route::get('/en/specialty/mechanics', [SpecialtyController::class, 'mechanics']);
Route::get('/en/specialty/chemical', [SpecialtyController::class, 'chemical']);
Route::get('/en/specialty/steel-industry', [SpecialtyController::class, 'steel_industry']);
Route::get('/en/contact', [EnContactController::class, 'index']);
