<!doctype html>
<html class="no-js" lang="pt-br">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Tradsul - Steelworks</title>
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- STYLES -->
    <?php echo $__env->make('en.partials.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>

<body>
<!-- page wrapper -->
<div class="page-wrapper">

    <!-- Header Main Area -->
    <header class="site-header header-style-3">
        <?php echo $__env->make('en.partials.top-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="site-header-menu d-flex justify-content-between align-items-center">
            <div class="container-fluid g-0">
                <div class="row g-0">
                    <div class="col-md-12">
                        <div class="d-flex align-items-center justify-content-between">
                            <?php echo $__env->make('en.partials.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Main Area End Here -->


    <!-- Title Bar -->
    <div class="pbmit-title-bar-wrapper es-siderurgia">
        <div class="container">
            <div class="pbmit-title-bar-content">
                <div class="pbmit-title-bar-content-inner">
                    <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner">
                            <h1 class="pbmit-tbar-title text-white">Steelworks</h1>
                        </div>
                    </div>
                    <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                            <span><a title="" href="#" class="home"><span>Home</span></a></span>
                            <span class="sep">-</span>
                            <span><span>Work Area</span></span>
                            <span class="sep">-</span>
                            <span><span class="post-root post post-post current-item">Steelworks</span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Title Bar End-->


    <!-- Page Content -->
    <div class="page-content pbmit-bg-color-light">


        <!-- Candidate  Details-->
        <section class="section-lg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="row align-items-center">
                            <div class="col-md-12 col-lg-4">
                                <div class="pbmit-team-details-inner">
                                    <div class="pbmit-team-img">
                                        <img src="<?php echo e(asset('assets/images/specialty/siderurgia.webp')); ?>"
                                             class="w-100" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-8">
                                <div class="pbmit-team-summary">
                                    <h4 class="pbmit-team-designation">Work Area</h4>
                                    <h2 class="pbmit-team-title">Steelworks</h2>
                                    <p>
                                        Steelworks expertise is specialized in the investigation, analysis, and
                                        evaluation of technical issues related to the production and processing of
                                        metals and steel.
                                    </p>
                                    <p>
                                        Our metallurgical and materials engineering team consists of masters and PhD
                                        specialists with years of experience in the steel industry, alongside solid
                                        experience in research and development (R&D), processing, and materials
                                        characterization.
                                    </p>
                                    <p>
                                        We focus on investigating failures in components and equipment in service,
                                        conducting a comprehensive analysis that clarifies the failure, identifies the
                                        causal mechanism, and ultimately determines the root cause.
                                    </p>
                                    <p>
                                        Our studies follow scientific methodologies applied to Failure Analysis, and our
                                        team has access to a wide range of resources that contribute to identifying the
                                        factors responsible for the failure. This includes metallurgical and mechanical
                                        testing, Finite Element Analysis (FEA), and other advanced techniques.
                                    </p>
                                    <p>
                                        Committed to excellence, we ensure that our steelworks investigations are
                                        conducted with precision and technical rigor, providing reliable results and
                                        contributing to the optimization of industrial processes and the improvement of
                                        quality in metal and steel production.
                                    </p>
                                    <p>
                                        <strong>Here’s how we can assist you!</strong>
                                    <ul>
                                        <li>- Steel Industry Processes;</li>
                                        <li>- Integrated and Non-Integrated Plants;</li>
                                        <li>- Steelmaking Inputs;</li>
                                        <li>- Environmental Control;</li>
                                        <li>- Process Cost and Quality;</li>
                                    </ul>
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- Candidate  Details end -->
    </div>
    <!-- Page Content End -->

    <!-- Footer -->
    <?php echo $__env->make('en.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Footer End -->

</div>
<!-- page wrapper End -->

<!-- Search Box Start Here -->
<div class="pbmit-search-overlay">
    <div class="pbmit-icon-close"></div>
    <div class="pbmit-search-outer">
        <form class="pbmit-site-searchform">
            <input type="search" class="form-control field searchform-s" name="Pesquisar …"
                   placeholder="Pesquisar …">
            <button type="submit">
                <i class="pbmit-base-icon-search-1"></i>
            </button>
        </form>
    </div>
</div>
<!-- Search Box End Here -->

<!-- JS
     ============================================ -->
<?php echo $__env->make('en.partials.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    $(".mn-specialty").addClass("active");
</script>
</body>

</html>
<?php /**PATH C:\htdocs\tradsul\resources\views/en/specialty/steel-industry.blade.php ENDPATH**/ ?>